/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.packets;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.components.GraveComponent;
import com.b1n_ry.yigd.config.ClaimPriority;
import com.b1n_ry.yigd.config.CommandConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathInfoManager;
import com.b1n_ry.yigd.data.GraveStatus;
import com.b1n_ry.yigd.packets.LightGraveData;
import com.b1n_ry.yigd.packets.LightPlayerData;
import com.b1n_ry.yigd.packets.PacketIdentifiers;
import com.b1n_ry.yigd.util.DropRule;
import com.b1n_ry.yigd.util.GraveCompassHelper;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ServerPacketHandler {
    public static void registerReceivers() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.GRAVE_RESTORE_C2S, (server, player, handler, buf, responseSender) -> {
            YigdConfig config = YigdConfig.getConfig();
            if (!Permissions.check((class_1297)player, (String)"yigd.command.restore", (int)config.commandConfig.restorePermissionLevel)) {
                player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.permission_fail"));
                return;
            }
            UUID graveId = buf.method_10790();
            boolean itemsInGrave = buf.readBoolean();
            boolean itemsDeleted = buf.readBoolean();
            boolean itemsKept = buf.readBoolean();
            boolean itemsDropped = buf.readBoolean();
            server.execute(() -> {
                Optional<GraveComponent> maybeComponent = DeathInfoManager.INSTANCE.getGrave(graveId);
                maybeComponent.ifPresentOrElse(component -> {
                    GameProfile owner = component.getOwner();
                    class_3222 restoringPlayer = server.method_3760().method_14602(owner.getId());
                    if (restoringPlayer == null) {
                        player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.restore.fail.offline_player"));
                        return;
                    }
                    component.applyToPlayer(restoringPlayer, restoringPlayer.method_51469(), restoringPlayer.method_19538(), true, dropRule -> switch (dropRule) {
                        default -> throw new IncompatibleClassChangeError();
                        case DropRule.KEEP -> itemsKept;
                        case DropRule.DESTROY -> itemsDeleted;
                        case DropRule.DROP -> itemsDropped;
                        case DropRule.PUT_IN_GRAVE -> itemsInGrave;
                    });
                    if (itemsInGrave) {
                        component.setStatus(GraveStatus.CLAIMED);
                        component.removeGraveBlock();
                    }
                    player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.restore.success"));
                }, () -> player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.restore.fail")));
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.GRAVE_ROBBING_C2S, (server, player, handler, buf, responseSender) -> {
            YigdConfig config = YigdConfig.getConfig();
            if (!Permissions.check((class_1297)player, (String)"yigd.command.rob", (int)config.commandConfig.robPermissionLevel)) {
                player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.permission_fail"));
                return;
            }
            UUID graveId = buf.method_10790();
            boolean itemsInGrave = buf.readBoolean();
            boolean itemsDeleted = buf.readBoolean();
            boolean itemsKept = buf.readBoolean();
            boolean itemsDropped = buf.readBoolean();
            server.execute(() -> {
                Optional<GraveComponent> maybeComponent = DeathInfoManager.INSTANCE.getGrave(graveId);
                maybeComponent.ifPresentOrElse(component -> {
                    component.applyToPlayer(player, player.method_51469(), player.method_19538(), false, dropRule -> switch (dropRule) {
                        default -> throw new IncompatibleClassChangeError();
                        case DropRule.KEEP -> itemsKept;
                        case DropRule.DESTROY -> itemsDeleted;
                        case DropRule.DROP -> itemsDropped;
                        case DropRule.PUT_IN_GRAVE -> itemsInGrave;
                    });
                    if (itemsInGrave) {
                        component.setStatus(GraveStatus.CLAIMED);
                        component.removeGraveBlock();
                    }
                    player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.rob.success"));
                }, () -> player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.rob.fail")));
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.GRAVE_DELETE_C2S, (server, player, handler, buf, responseSender) -> {
            YigdConfig config = YigdConfig.getConfig();
            if (!Permissions.check((class_1297)player, (String)"yigd.command.delete", (int)config.commandConfig.deletePermissionLevel)) {
                player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.permission_fail"));
                return;
            }
            UUID graveId = buf.method_10790();
            server.execute(() -> {
                class_1269 deleted = DeathInfoManager.INSTANCE.delete(graveId);
                DeathInfoManager.INSTANCE.method_80();
                String translatable = switch (deleted) {
                    case class_1269.field_5812 -> "text.yigd.command.delete.success";
                    case class_1269.field_5811 -> "text.yigd.command.delete.pass";
                    case class_1269.field_5814 -> "text.yigd.command.delete.fail";
                    default -> "If you see this, congratulations. You've broken YIGD";
                };
                player.method_43496((class_2561)class_2561.method_43471((String)translatable));
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.GRAVE_LOCKING_C2S, (server, player, handler, buf, responseSender) -> {
            YigdConfig config = YigdConfig.getConfig();
            if (!Permissions.check((class_1297)player, (String)"yigd.command.locking", (int)config.commandConfig.unlockPermissionLevel)) {
                player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.permission_fail"));
                return;
            }
            UUID graveId = buf.method_10790();
            boolean lockState = buf.readBoolean();
            server.execute(() -> {
                Optional<GraveComponent> component = DeathInfoManager.INSTANCE.getGrave(graveId);
                component.ifPresentOrElse(grave -> grave.setLocked(lockState), () -> player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.lock.fail")));
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.GRAVE_OBTAIN_KEYS_C2S, (server, player, handler, buf, responseSender) -> {
            YigdConfig config = YigdConfig.getConfig();
            if (!config.extraFeatures.graveKeys.enabled || !config.extraFeatures.graveKeys.obtainableFromGui) {
                player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.permission_fail"));
                return;
            }
            UUID graveId = buf.method_10790();
            server.execute(() -> {
                Optional<GraveComponent> component = DeathInfoManager.INSTANCE.getGrave(graveId);
                component.ifPresentOrElse(grave -> {
                    class_1799 key = new class_1799((class_1935)Yigd.GRAVE_KEY_ITEM);
                    Yigd.GRAVE_KEY_ITEM.bindStackToGrave(graveId, grave.getOwner(), key);
                    player.method_7270(key);
                }, () -> player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.obtain_key.fail")));
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.GRAVE_OBTAIN_COMPASS_C2S, (server, player, handler, buf, responseSender) -> {
            YigdConfig config = YigdConfig.getConfig();
            if (!config.extraFeatures.graveCompass.cloneRecoveryCompassWithGUI) {
                player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.permission_fail"));
                return;
            }
            UUID graveId = buf.method_10790();
            server.execute(() -> {
                Optional<GraveComponent> component = DeathInfoManager.INSTANCE.getGrave(graveId);
                component.ifPresentOrElse(grave -> GraveCompassHelper.giveCompass(player, graveId, grave.getPos(), grave.getWorldRegistryKey()), () -> player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.obtain_compass.fail")));
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.GRAVE_OVERVIEW_REQUEST_C2S, (server, player, handler, buf, responseSender) -> {
            YigdConfig config = YigdConfig.getConfig();
            if (!Permissions.check((class_1297)player, (String)"yigd.command.view_self", (int)config.commandConfig.viewSelfPermissionLevel)) {
                player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.permission_fail"));
                return;
            }
            UUID graveId = buf.method_10790();
            Optional<GraveComponent> component = DeathInfoManager.INSTANCE.getGrave(graveId);
            component.ifPresentOrElse(grave -> ServerPacketHandler.sendGraveOverviewPacket(player, grave), () -> player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.view_self.fail")));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.GRAVE_SELECT_REQUEST_C2S, (server, player, handler, buf, responseSender) -> {
            YigdConfig config = YigdConfig.getConfig();
            if (!Permissions.check((class_1297)player, (String)"yigd.command.view_user", (int)config.commandConfig.viewUserPermissionLevel)) {
                player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.permission_fail"));
                return;
            }
            GameProfile profile = buf.method_43623();
            List<GraveComponent> components = DeathInfoManager.INSTANCE.getBackupData(profile);
            ArrayList<LightGraveData> lightGraveData = new ArrayList<LightGraveData>();
            for (GraveComponent component : components) {
                lightGraveData.add(component.toLightData());
            }
            ServerPacketHandler.sendGraveSelectionPacket(player, profile, lightGraveData);
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.CONFIG_UPDATE_C2S, (server, player, handler, buf, responseSender) -> {
            ClaimPriority claimPriority = (ClaimPriority)buf.method_10818(ClaimPriority.class);
            ClaimPriority robPriority = (ClaimPriority)buf.method_10818(ClaimPriority.class);
            UUID playerId = player.method_5667();
            Yigd.CLAIM_PRIORITIES.put(playerId, claimPriority);
            Yigd.ROB_PRIORITIES.put(playerId, robPriority);
            Yigd.LOGGER.info("Priority overwritten for player {}. Claiming: {} / Robbing: {}", new Object[]{player.method_7334().getName(), claimPriority.name(), robPriority.name()});
        });
    }

    public static void sendGraveOverviewPacket(class_3222 player, GraveComponent component) {
        YigdConfig config = YigdConfig.getConfig();
        CommandConfig commandConfig = YigdConfig.getConfig().commandConfig;
        class_2540 buf = PacketByteBufs.create();
        buf.method_10794(component.toNbt());
        buf.writeBoolean(Permissions.check((class_1297)player, (String)"yigd.command.restore", (int)commandConfig.restorePermissionLevel));
        buf.writeBoolean(Permissions.check((class_1297)player, (String)"yigd.command.rob", (int)commandConfig.robPermissionLevel));
        buf.writeBoolean(Permissions.check((class_1297)player, (String)"yigd.command.delete", (int)commandConfig.deletePermissionLevel));
        buf.writeBoolean(Permissions.check((class_1297)player, (String)"yigd.command.locking", (int)commandConfig.unlockPermissionLevel));
        buf.writeBoolean(config.extraFeatures.graveKeys.enabled && config.extraFeatures.graveKeys.obtainableFromGui);
        buf.writeBoolean(config.extraFeatures.graveCompass.cloneRecoveryCompassWithGUI && player.method_31548().method_18861(class_1802.field_38747) > 0);
        ServerPlayNetworking.send((class_3222)player, (class_2960)PacketIdentifiers.GRAVE_OVERVIEW_S2C, (class_2540)buf);
    }

    public static void sendGraveSelectionPacket(class_3222 player, GameProfile ofUser, List<LightGraveData> data) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(data.size());
        for (LightGraveData grave : data) {
            buf.method_10794(grave.toNbt());
        }
        buf.method_43616(ofUser);
        ServerPlayNetworking.send((class_3222)player, (class_2960)PacketIdentifiers.GRAVE_SELECTION_S2C, (class_2540)buf);
    }

    public static void sendPlayerSelectionPacket(class_3222 player, List<LightPlayerData> data) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(data.size());
        for (LightPlayerData playerData : data) {
            buf.method_10794(playerData.toNbt());
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)PacketIdentifiers.PLAYER_SELECTION_S2C, (class_2540)buf);
    }

    public static void sendConfigSyncPacket(class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        YigdConfig config = YigdConfig.getConfig();
        buf.writeBoolean(config.graveConfig.retrieveMethods.onBreak);
        buf.writeBoolean(config.graveRendering.useGlowingEffect);
        buf.writeInt(config.graveRendering.glowingDistance);
        buf.writeDouble(config.extraFeatures.deathSightEnchant.range);
        ServerPlayNetworking.send((class_3222)player, (class_2960)PacketIdentifiers.CONFIG_SYNC_S2C, (class_2540)buf);
    }
}

