/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.components;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.compat.CompatComponent;
import com.b1n_ry.yigd.compat.InvModCompat;
import com.b1n_ry.yigd.config.InventoryConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.data.GraveItem;
import com.b1n_ry.yigd.events.AdjustDropRuleEvent;
import com.b1n_ry.yigd.events.DropItemEvent;
import com.b1n_ry.yigd.events.DropRuleEvent;
import com.b1n_ry.yigd.util.DropRule;
import com.b1n_ry.yigd.util.GraveItemModificationConsumer;
import com.b1n_ry.yigd.util.GraveOverrideAreas;
import com.b1n_ry.yigd.util.YigdTags;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1264;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class InventoryComponent {
    private final class_2371<GraveItem> items = class_2371.method_10211();
    private final Map<String, CompatComponent<?>> modInventoryItems;
    public final int mainSize;
    public final int armorSize;
    public final int offHandSize;
    private static final Random RANDOM = new Random();
    public static final GraveItem EMPTY_GRAVE_ITEM = new GraveItem(class_1799.field_8037, GraveOverrideAreas.INSTANCE.defaultDropRule);

    public InventoryComponent(class_3222 player) {
        for (class_1799 stack : this.getInventoryItems(player)) {
            this.items.add((Object)new GraveItem(stack, DropRule.PUT_IN_GRAVE));
        }
        this.modInventoryItems = this.getModInventoryItems(player);
        class_1661 inventory = player.method_31548();
        this.mainSize = inventory.field_7547.size();
        this.armorSize = inventory.field_7548.size();
        this.offHandSize = inventory.field_7544.size();
    }

    private InventoryComponent(class_2371<GraveItem> items, Map<String, CompatComponent<?>> modInventoryItems, int mainSize, int armorSize, int offHandSize) {
        this.items.addAll(items);
        this.modInventoryItems = modInventoryItems;
        this.mainSize = mainSize;
        this.armorSize = armorSize;
        this.offHandSize = offHandSize;
    }

    public class_2371<GraveItem> getItems() {
        return this.items;
    }

    public class_2371<class_1799> getAllExtraItems(boolean withoutEmpty) {
        class_2371 stacks = class_2371.method_10211();
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            for (GraveItem graveItem : compatComponent.getAsGraveItemList()) {
                class_1799 stack = graveItem.stack;
                if (withoutEmpty && stack.method_7960()) continue;
                stacks.add((Object)stack);
            }
        }
        return stacks;
    }

    public boolean removeItem(Predicate<class_1799> predicate, int itemCount) {
        predicate = predicate.and(stack -> stack.method_7947() >= itemCount);
        for (GraveItem graveItem : this.items) {
            class_1799 stack2 = graveItem.stack;
            if (!predicate.test(stack2)) continue;
            stack2.method_7934(itemCount);
            return true;
        }
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            if (!compatComponent.removeItem(predicate, itemCount)) continue;
            return true;
        }
        return false;
    }

    private class_2371<class_1799> getInventoryItems(class_3222 player) {
        class_1661 inventory = player.method_31548();
        class_2371 items = class_2371.method_10213((int)inventory.method_5439(), (Object)class_1799.field_8037);
        for (int i = 0; i < inventory.method_5439(); ++i) {
            items.set(i, (Object)inventory.method_5438(i));
        }
        return items;
    }

    private Map<String, CompatComponent<?>> getModInventoryItems(class_3222 player) {
        HashMap modInventories = new HashMap();
        for (InvModCompat<?> compatMod : InvModCompat.invCompatMods) {
            modInventories.put(compatMod.getModName(), compatMod.getNewComponent(player));
        }
        return modInventories;
    }

    public void onDeath(DeathContext context) {
        YigdConfig config = YigdConfig.getConfig();
        if (config.inventoryConfig.dropPlayerHead) {
            class_1799 playerHead = new class_1799((class_1935)class_1802.field_8575);
            class_2487 profileNbt = class_2512.method_10684((class_2487)new class_2487(), (GameProfile)context.player().method_7334());
            playerHead.method_7959("SkullOwner", (class_2520)profileNbt);
            this.items.add((Object)new GraveItem(playerHead, GraveOverrideAreas.INSTANCE.defaultDropRule));
        }
        this.handleDropRules(context);
        InventoryComponent dropInventory = this.filteredInv(dropRule -> dropRule == DropRule.DROP);
        dropInventory.dropAll(context.world(), context.deathPos());
    }

    private void handleDropRules(DeathContext context) {
        for (int i = 0; i < this.items.size(); ++i) {
            GraveItem graveItem = (GraveItem)this.items.get(i);
            class_1799 item = graveItem.stack;
            if (item.method_7960()) continue;
            graveItem.dropRule = ((DropRuleEvent)DropRuleEvent.EVENT.invoker()).getDropRule(item, i, context, true);
        }
        for (InvModCompat<?> compatMod : InvModCompat.invCompatMods) {
            String modName = compatMod.getModName();
            CompatComponent<?> compatComponent = this.modInventoryItems.get(modName);
            compatComponent.handleDropRules(context);
        }
        ((AdjustDropRuleEvent)AdjustDropRuleEvent.EVENT.invoker()).adjustDropRules(this, context);
    }

    public void applyLoss() {
        int to;
        int from;
        YigdConfig config = YigdConfig.getConfig();
        InventoryConfig.ItemLossConfig itemLoss = config.inventoryConfig.itemLoss;
        if (itemLoss.usePercentRange) {
            class_2371 vanillaStacks = class_2371.method_10211();
            for (GraveItem graveItem : this.items) {
                if (graveItem.stack.method_7960() || graveItem.dropRule == DropRule.DESTROY) continue;
                vanillaStacks.add((Object)graveItem.stack);
            }
            int itemCount = vanillaStacks.size();
            if (!itemLoss.affectStacks) {
                itemCount = 0;
                for (class_1799 stack : vanillaStacks) {
                    itemCount += stack.method_7947();
                }
            }
            from = (int)((float)(itemCount * itemLoss.lossRangeFrom) / 100.0f);
            to = (int)((float)(itemCount * itemLoss.lossRangeTo) / 100.0f);
        } else {
            from = itemLoss.lossRangeFrom;
            to = itemLoss.lossRangeTo;
        }
        int amount = from < to ? new Random().nextInt(from, to + 1) : from;
        for (int i = 0; i < amount; ++i) {
            if (Math.random() > (double)itemLoss.percentChanceOfLoss / 100.0) continue;
            this.loseRandomItem();
        }
    }

    private void loseRandomItem() {
        YigdConfig config = YigdConfig.getConfig();
        InventoryConfig.ItemLossConfig itemLoss = config.inventoryConfig.itemLoss;
        ArrayList<Integer> itemSlots = new ArrayList<Integer>();
        ArrayList<Integer> slotWeights = new ArrayList<Integer>();
        int totalLosableItemCount = 0;
        int vanillaLimit = this.items.size();
        for (int i = 0; i < vanillaLimit; ++i) {
            GraveItem graveItem = (GraveItem)this.items.get(i);
            class_1799 class_17992 = graveItem.stack;
            if (class_17992.method_7960() || graveItem.dropRule == DropRule.KEEP && !itemLoss.canLoseSoulbound || class_17992.method_31573(YigdTags.LOSS_IMMUNE)) continue;
            itemSlots.add(i);
            int itemCount = class_17992.method_7947();
            slotWeights.add(itemCount);
            totalLosableItemCount += itemCount;
        }
        class_2371 extraItems = class_2371.method_10211();
        if (itemLoss.includeModdedInventories) {
            for (CompatComponent compatComponent : this.modInventoryItems.values()) {
                for (GraveItem graveItem : compatComponent.getAsGraveItemList()) {
                    if (graveItem.stack.method_7960() || graveItem.dropRule == DropRule.KEEP && !itemLoss.canLoseSoulbound || graveItem.stack.method_31573(YigdTags.LOSS_IMMUNE)) continue;
                    extraItems.add((Object)graveItem);
                }
            }
            for (int i = 0; i < extraItems.size(); ++i) {
                itemSlots.add(vanillaLimit + i);
                int n = ((GraveItem)extraItems.get((int)i)).stack.method_7947();
                slotWeights.add(n);
                totalLosableItemCount += n;
            }
        }
        if (itemSlots.isEmpty()) {
            return;
        }
        DropRule appliedDropRule = itemLoss.lossDropRule;
        if (itemLoss.weightedSelection) {
            random = RANDOM.nextInt(totalLosableItemCount);
            int i = 0;
            int j = 0;
            while (random >= j) {
                j += ((Integer)slotWeights.get(i)).intValue();
                ++i;
            }
            int n = (Integer)itemSlots.get(i - 1);
        } else {
            random = RANDOM.nextInt(itemSlots.size());
            int n = (Integer)itemSlots.get(random);
        }
        if (itemLoss.affectStacks) {
            if (var9_18 >= vanillaLimit) {
                GraveItem toBeRemoved = (GraveItem)extraItems.get((int)(var9_18 - vanillaLimit));
                toBeRemoved.dropRule = appliedDropRule;
            } else {
                ((GraveItem)this.items.get((int)var9_18)).dropRule = appliedDropRule;
            }
        } else {
            class_1799 stack = var9_18 >= vanillaLimit ? ((GraveItem)extraItems.get((int)(var9_18 - vanillaLimit))).stack : ((GraveItem)this.items.get((int)var9_18)).stack;
            stack.method_7934(1);
            GraveItem lostItem = new GraveItem(stack.method_46651(1), appliedDropRule);
            this.mergeSingleItem(lostItem, false);
        }
    }

    public void dropAll(class_3218 world, class_243 pos) {
        for (GraveItem graveItem : this.items) {
            class_1799 stack = graveItem.stack;
            if (stack.method_7960()) continue;
            InventoryComponent.dropItemIfToBeDropped(stack, pos.field_1352, pos.field_1351, pos.field_1350, world);
        }
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            compatComponent.dropItems(world, pos);
        }
    }

    public void dropGraveItems(class_3218 world, class_243 pos) {
        for (GraveItem graveItem : this.items) {
            class_1799 stack = graveItem.stack;
            if (stack.method_7960() || graveItem.dropRule != DropRule.PUT_IN_GRAVE) continue;
            graveItem.dropRule = DropRule.DROP;
            InventoryComponent.dropItemIfToBeDropped(stack, pos.field_1352, pos.field_1351, pos.field_1350, world);
        }
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            compatComponent.dropGraveItems(world, pos);
        }
    }

    public class_2371<class_1799> merge(InventoryComponent mergingComponent, class_3222 merger) {
        class_2371<GraveItem> extraItems = this.merge(mergingComponent, merger, true);
        class_2371 extraItemStacks = class_2371.method_10211();
        for (GraveItem graveItem : extraItems) {
            extraItemStacks.add((Object)graveItem.stack);
        }
        return extraItemStacks;
    }

    public class_2371<GraveItem> mergeKeepDropRules(InventoryComponent mergingComponent, class_3222 merger) {
        return this.merge(mergingComponent, merger, false);
    }

    private class_2371<GraveItem> merge(InventoryComponent mergingComponent, class_3222 merger, boolean mergeDropRules) {
        YigdConfig config = YigdConfig.getConfig();
        class_2371 extraItems = class_2371.method_10211();
        for (int i = 0; i < mergingComponent.items.size(); ++i) {
            int combinationSlot;
            int currentComponentIndex;
            if (i < mergingComponent.mainSize) {
                groupIndex = i;
                currentComponentIndex = groupIndex < this.mainSize ? groupIndex : 0;
            } else if (i < mergingComponent.mainSize + mergingComponent.armorSize) {
                groupIndex = i - mergingComponent.mainSize;
                currentComponentIndex = groupIndex < this.armorSize ? groupIndex + this.mainSize : this.mainSize;
            } else if (i < mergingComponent.mainSize + mergingComponent.armorSize + mergingComponent.offHandSize) {
                groupIndex = i - (mergingComponent.mainSize + mergingComponent.armorSize);
                currentComponentIndex = groupIndex < this.offHandSize ? groupIndex + this.mainSize + this.armorSize : this.mainSize + this.armorSize;
            } else {
                groupIndex = i - (mergingComponent.mainSize + mergingComponent.armorSize + mergingComponent.offHandSize);
                currentComponentIndex = groupIndex + this.mainSize + this.armorSize + this.offHandSize;
            }
            GraveItem mergingGraveItem = ((GraveItem)mergingComponent.items.get(i)).copy();
            if (currentComponentIndex > this.items.size()) {
                extraItems.add((Object)mergingGraveItem);
                continue;
            }
            Object currentGraveItem = (GraveItem)this.items.get(currentComponentIndex);
            if (config.graveConfig.treatBindingCurse && i >= mergingComponent.mainSize && i < mergingComponent.mainSize + mergingComponent.armorSize && class_1890.method_8224((class_1799)mergingGraveItem.stack)) {
                if (!((GraveItem)currentGraveItem).stack.method_7960()) {
                    extraItems.add(currentGraveItem);
                }
                this.items.set(currentComponentIndex, (Object)EMPTY_GRAVE_ITEM);
                currentGraveItem = (GraveItem)this.items.get(currentComponentIndex);
            }
            if (config.graveConfig.mergeStacksOnRetrieve && (combinationSlot = this.findMatchingStackSlot(mergingGraveItem, mergeDropRules)) != -1) {
                this.mergeItemInSlot(mergingGraveItem.stack, combinationSlot);
            }
            if (mergingGraveItem.stack.method_7960()) continue;
            if (((GraveItem)currentGraveItem).stack.method_7960()) {
                this.items.set(currentComponentIndex, (Object)mergingGraveItem);
                continue;
            }
            extraItems.add((Object)mergingGraveItem);
        }
        for (InvModCompat<?> modCompat : InvModCompat.invCompatMods) {
            String modName = modCompat.getModName();
            if (!mergingComponent.modInventoryItems.containsKey(modName)) continue;
            CompatComponent<?> mergingCompatComponent = mergingComponent.modInventoryItems.get(modName);
            if (!this.modInventoryItems.containsKey(modName)) {
                for (GraveItem graveItem : mergingCompatComponent.getAsGraveItemList()) {
                    if (graveItem.stack.method_7960()) continue;
                    extraItems.add((Object)graveItem.copy());
                }
                continue;
            }
            CompatComponent<?> compatComponent = this.modInventoryItems.get(modName);
            class_2371<GraveItem> extraModItems = compatComponent.merge(mergingCompatComponent, merger);
            extraItems.addAll(extraModItems);
        }
        this.addStacksToMain((class_2371<GraveItem>)extraItems, mergeDropRules);
        return extraItems;
    }

    public void mergeSingleItem(GraveItem graveItem, boolean mergeDropRules) {
        while (!graveItem.stack.method_7960()) {
            int addToSlot = this.findMatchingStackSlot(graveItem, mergeDropRules);
            if (addToSlot == -1 && (addToSlot = this.findEmptySlot()) == -1) {
                this.addExtraGraveItem(graveItem);
                break;
            }
            class_1799 addToStack = ((GraveItem)this.items.get((int)addToSlot)).stack;
            if (addToStack.method_7960()) {
                this.items.set(addToSlot, (Object)graveItem);
                break;
            }
            this.mergeItemInSlot(graveItem.stack, addToSlot);
            if (!graveItem.stack.method_7960()) continue;
            break;
        }
    }

    public void addExtraGraveItem(GraveItem graveItem) {
        this.items.add((Object)graveItem);
    }

    private int findMatchingStackSlot(GraveItem graveItem, boolean mergeDropRules) {
        class_1799 graveStack = graveItem.stack;
        for (int i = 0; i < this.items.size(); ++i) {
            GraveItem iGraveItem = (GraveItem)this.items.get(i);
            class_1799 iStack = iGraveItem.stack;
            if (!class_1799.method_31577((class_1799)graveStack, (class_1799)iStack) || !iStack.method_7946() || iStack.method_7914() <= iStack.method_7947() || !mergeDropRules && graveItem.dropRule != iGraveItem.dropRule) continue;
            return i;
        }
        return -1;
    }

    private void mergeItemInSlot(class_1799 toMerge, int slot) {
        class_1799 mergeTo = ((GraveItem)this.items.get((int)slot)).stack;
        int remaining = mergeTo.method_7914() - mergeTo.method_7947();
        int ableToAdd = Math.min(toMerge.method_7947(), remaining);
        mergeTo.method_7933(ableToAdd);
        toMerge.method_7934(ableToAdd);
    }

    public class_2371<class_1799> pullBindingCurseItems(class_3222 playerRef) {
        class_2371 bindingItems = class_2371.method_10211();
        for (int i = 0; i < this.armorSize; ++i) {
            class_1799 armorStack = ((GraveItem)this.items.get((int)(this.mainSize + i))).stack;
            if (!class_1890.method_8224((class_1799)armorStack)) continue;
            bindingItems.add((Object)armorStack);
            this.items.set(this.mainSize + i, (Object)EMPTY_GRAVE_ITEM);
        }
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            bindingItems.addAll(compatComponent.pullBindingCurseItems(playerRef));
        }
        return bindingItems;
    }

    private void addStacksToMain(class_2371<GraveItem> extraItems, boolean mergeDropRules) {
        YigdConfig config = YigdConfig.getConfig();
        while (!extraItems.isEmpty()) {
            GraveItem graveItem = (GraveItem)extraItems.get(0);
            int addToSlot = -1;
            if (config.graveConfig.mergeStacksOnRetrieve) {
                addToSlot = this.findMatchingStackSlot(graveItem, mergeDropRules);
            }
            if (addToSlot == -1 && (addToSlot = this.findEmptySlot()) == -1) {
                return;
            }
            class_1799 addToStack = ((GraveItem)this.items.get((int)addToSlot)).stack;
            if (addToStack.method_7960()) {
                this.items.set(addToSlot, (Object)graveItem);
                extraItems.remove(0);
                continue;
            }
            this.mergeItemInSlot(graveItem.stack, addToSlot);
            if (!graveItem.stack.method_7960()) continue;
            extraItems.remove(0);
        }
    }

    private int findEmptySlot() {
        for (int i = 0; i < this.mainSize; ++i) {
            if (!((GraveItem)this.items.get((int)i)).stack.method_7960()) continue;
            return i;
        }
        return -1;
    }

    public boolean containsAny(Predicate<class_1799> itemPredicate, Predicate<String> modPredicate, Predicate<Integer> slotPredicate) {
        if (modPredicate.test("vanilla")) {
            for (int i = 0; i < this.items.size(); ++i) {
                GraveItem graveItem = (GraveItem)this.items.get(i);
                if (!slotPredicate.test(i) || !itemPredicate.test(graveItem.stack)) continue;
                return true;
            }
        }
        for (Map.Entry<String, CompatComponent<?>> entry : this.modInventoryItems.entrySet()) {
            CompatComponent<?> compatComponent = entry.getValue();
            if (!modPredicate.test(entry.getKey()) || !compatComponent.containsAny(itemPredicate)) continue;
            return true;
        }
        return false;
    }

    public void handleGraveItems(Predicate<String> modPredicate, GraveItemModificationConsumer modification) {
        if (modPredicate.test("vanilla")) {
            for (int i = 0; i < this.items.size(); ++i) {
                GraveItem graveItem = (GraveItem)this.items.get(i);
                modification.accept(graveItem.stack, i, graveItem);
            }
        }
        for (Map.Entry<String, CompatComponent<?>> entry : this.modInventoryItems.entrySet()) {
            CompatComponent<?> compatComponent = entry.getValue();
            if (!modPredicate.test(entry.getKey())) continue;
            compatComponent.handleGraveItems(modification);
        }
    }

    public boolean isGraveEmpty() {
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            if (!compatComponent.containsGraveItems()) continue;
            return false;
        }
        for (GraveItem graveItem : this.items) {
            if (graveItem.stack.method_7960() || graveItem.dropRule != DropRule.PUT_IN_GRAVE) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            if (compatComponent.isEmpty()) continue;
            return false;
        }
        for (GraveItem graveItem : this.items) {
            if (graveItem.stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public int graveSize() {
        int size = 0;
        for (CompatComponent<?> compatComponent : this.modInventoryItems.values()) {
            for (GraveItem graveItem : compatComponent.getAsGraveItemList()) {
                if (graveItem.stack.method_7960() || graveItem.dropRule != DropRule.PUT_IN_GRAVE) continue;
                ++size;
            }
        }
        for (GraveItem graveItem : this.items) {
            if (graveItem.stack.method_7960() || graveItem.dropRule != DropRule.PUT_IN_GRAVE) continue;
            ++size;
        }
        return size;
    }

    public class_2371<class_1799> applyToPlayer(class_3222 player) {
        class_2371 extraItems = class_2371.method_10211();
        class_1661 inventory = player.method_31548();
        int invMainSize = inventory.field_7547.size();
        int invArmorSize = inventory.field_7548.size();
        int invOffHandSize = inventory.field_7544.size();
        for (int i = 0; i < this.items.size(); ++i) {
            int playerInvIndex;
            if (i < this.mainSize) {
                groupIndex = i;
                playerInvIndex = groupIndex < invMainSize ? groupIndex : -1;
            } else if (i < this.mainSize + this.armorSize) {
                groupIndex = i - this.mainSize;
                playerInvIndex = groupIndex < invArmorSize ? groupIndex + invMainSize : -1;
            } else if (i < this.mainSize + this.armorSize + this.offHandSize) {
                groupIndex = i - (this.mainSize + this.armorSize);
                playerInvIndex = groupIndex < invOffHandSize ? groupIndex + invMainSize + invArmorSize : -1;
            } else {
                groupIndex = i - (this.mainSize + this.armorSize + this.offHandSize);
                playerInvIndex = groupIndex + invMainSize + invArmorSize + invOffHandSize;
            }
            class_1799 stack = ((GraveItem)this.items.get((int)i)).stack.method_7972();
            if (playerInvIndex >= inventory.method_5439() || playerInvIndex == -1) {
                extraItems.add((Object)stack);
                continue;
            }
            inventory.method_5447(playerInvIndex, stack);
        }
        for (InvModCompat<?> modCompat : InvModCompat.invCompatMods) {
            String modName = modCompat.getModName();
            if (!this.modInventoryItems.containsKey(modName)) continue;
            class_2371<class_1799> extraModItems = this.modInventoryItems.get(modName).storeToPlayer(player);
            extraItems.addAll(extraModItems);
        }
        return extraItems;
    }

    public InventoryComponent filteredInv(Predicate<DropRule> filter) {
        class_2371 filteredItems = class_2371.method_10211();
        for (GraveItem graveItem : this.items) {
            if (filter.test(graveItem.dropRule)) {
                filteredItems.add((Object)graveItem);
                continue;
            }
            filteredItems.add((Object)EMPTY_GRAVE_ITEM);
        }
        HashMap filteredModInventories = new HashMap();
        for (InvModCompat<?> compatMod : InvModCompat.invCompatMods) {
            String modName = compatMod.getModName();
            if (!this.modInventoryItems.containsKey(modName)) continue;
            CompatComponent<?> compatInv = this.modInventoryItems.get(modName);
            CompatComponent<?> filteredCompatInv = compatInv.filterInv(filter);
            filteredModInventories.put(modName, filteredCompatInv);
        }
        return new InventoryComponent((class_2371<GraveItem>)filteredItems, filteredModInventories, this.mainSize, this.armorSize, this.offHandSize);
    }

    public void clear() {
        Collections.fill(this.items, EMPTY_GRAVE_ITEM);
        for (CompatComponent<?> component : this.modInventoryItems.values()) {
            component.clear();
        }
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        class_2487 vanillaInventoryNbt = InventoryComponent.listToNbt(this.items, graveItem -> {
            class_2487 itemNbt = new class_2487();
            graveItem.stack.method_7953(itemNbt);
            itemNbt.method_10582("dropRule", graveItem.dropRule.name());
            return itemNbt;
        }, graveItem -> graveItem.stack.method_7960());
        vanillaInventoryNbt.method_10569("mainSize", this.mainSize);
        vanillaInventoryNbt.method_10569("armorSize", this.armorSize);
        vanillaInventoryNbt.method_10569("offHandSize", this.offHandSize);
        class_2487 modInventoriesNbt = new class_2487();
        for (InvModCompat<?> compatMod : InvModCompat.invCompatMods) {
            CompatComponent<?> compatInv;
            String modName = compatMod.getModName();
            if (!this.modInventoryItems.containsKey(modName) || (compatInv = this.modInventoryItems.get(modName)).isEmpty()) continue;
            modInventoriesNbt.method_10566(modName, (class_2520)compatInv.writeNbt());
        }
        nbt.method_10566("vanilla", (class_2520)vanillaInventoryNbt);
        nbt.method_10566("mods", (class_2520)modInventoriesNbt);
        return nbt;
    }

    public static InventoryComponent fromNbt(class_2487 nbt) {
        class_2487 vanillaInvNbt = nbt.method_10562("vanilla");
        class_2371<GraveItem> items = InventoryComponent.listFromNbt(vanillaInvNbt, itemNbt -> {
            class_1799 stack = class_1799.method_7915((class_2487)itemNbt);
            DropRule dropRule = GraveOverrideAreas.INSTANCE.defaultDropRule;
            if (itemNbt.method_10545("dropRule")) {
                dropRule = DropRule.valueOf(itemNbt.method_10558("dropRule"));
            }
            return new GraveItem(stack, dropRule);
        }, EMPTY_GRAVE_ITEM);
        int mainSize = vanillaInvNbt.method_10550("mainSize");
        int armorSize = vanillaInvNbt.method_10550("armorSize");
        int offHandSize = vanillaInvNbt.method_10550("offHandSize");
        class_2487 modInventoriesNbt = nbt.method_10562("mods");
        HashMap compatComponents = new HashMap();
        for (InvModCompat<?> compatMod : InvModCompat.invCompatMods) {
            String modName = compatMod.getModName();
            if (!modInventoriesNbt.method_10545(modName)) continue;
            class_2487 modNbt = modInventoriesNbt.method_10562(modName);
            compatComponents.put(modName, compatMod.readNbt(modNbt));
        }
        return new InventoryComponent(items, compatComponents, mainSize, armorSize, offHandSize);
    }

    public static <T> class_2487 listToNbt(class_2371<T> list, Function<T, class_2487> mappingFunction, Predicate<T> isEmpty) {
        return InventoryComponent.listToNbt(list, mappingFunction, isEmpty, "Items", "Slot");
    }

    public static <T> class_2487 listToNbt(class_2371<T> list, Function<T, class_2487> mappingFunction, Predicate<T> isEmpty, String listName, String itemName) {
        class_2487 nbt = new class_2487();
        int size = list.size();
        nbt.method_10569("size", size);
        class_2499 nbtList = new class_2499();
        for (int i = 0; i < size; ++i) {
            Object item = list.get(i);
            if (isEmpty.test(item)) continue;
            try {
                class_2487 itemNbt = mappingFunction.apply(item);
                itemNbt.method_10569(itemName, i);
                nbtList.add((Object)itemNbt);
                continue;
            }
            catch (Exception e) {
                Yigd.LOGGER.error("Failed to convert item to NBT: {}", item, (Object)e);
            }
        }
        nbt.method_10566(listName, (class_2520)nbtList);
        return nbt;
    }

    public static <T> class_2371<T> listFromNbt(class_2487 nbt, Function<class_2487, T> mappingFunction, T emptyValue) {
        return InventoryComponent.listFromNbt(nbt, mappingFunction, emptyValue, "Items", "Slot");
    }

    public static <T> class_2371<T> listFromNbt(class_2487 nbt, Function<class_2487, T> mappingFunction, T emptyValue, String listName, String itemName) {
        int size = nbt.method_10550("size");
        class_2371 list = class_2371.method_10213((int)size, emptyValue);
        class_2499 nbtList = nbt.method_10554(listName, 10);
        for (class_2520 element : nbtList) {
            class_2487 itemNbt = (class_2487)element;
            int index = itemNbt.method_10550(itemName);
            T item = mappingFunction.apply(itemNbt);
            list.set(index, item);
        }
        return list;
    }

    public static void dropItemIfToBeDropped(class_1799 stack, double x, double y, double z, class_3218 world) {
        if (((DropItemEvent)DropItemEvent.EVENT.invoker()).shouldDropItem(stack, x, y, z, world)) {
            class_1264.method_5449((class_1937)world, (double)x, (double)y, (double)z, (class_1799)stack.method_7972());
        }
    }

    public static void clearPlayer(class_3222 player) {
        class_1661 inventory = player.method_31548();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            inventory.method_5447(i, class_1799.field_8037);
        }
        for (InvModCompat<?> invModCompat : InvModCompat.invCompatMods) {
            invModCompat.clear(player);
        }
    }
}

