/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.client.gui;

import com.b1n_ry.yigd.client.gui.widget.WHoverButton;
import com.b1n_ry.yigd.client.gui.widget.WHoverToggleButton;
import com.b1n_ry.yigd.client.gui.widget.WItemStack;
import com.b1n_ry.yigd.components.GraveComponent;
import com.b1n_ry.yigd.components.InventoryComponent;
import com.b1n_ry.yigd.data.GraveItem;
import com.b1n_ry.yigd.packets.ClientPacketHandler;
import com.b1n_ry.yigd.util.DropRule;
import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.client.LightweightGuiDescription;
import io.github.cottonmc.cotton.gui.widget.WLabel;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WPlainPanel;
import io.github.cottonmc.cotton.gui.widget.WSprite;
import io.github.cottonmc.cotton.gui.widget.WText;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Insets;
import io.github.cottonmc.cotton.gui.widget.icon.Icon;
import io.github.cottonmc.cotton.gui.widget.icon.TextureIcon;
import java.awt.Point;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5321;

public class GraveOverviewGui
extends LightweightGuiDescription {
    private final GraveComponent graveComponent;
    private InventoryComponent visibleInventoryComponent;
    private final Set<WWidget> removables = new HashSet<WWidget>();
    private final WPlainPanel root;
    private final WPlainPanel invPanel;
    private final WPlainPanel buttonPanel;
    private boolean viewGraveItems = true;
    private boolean viewDeletedItems = false;
    private boolean viewSoulboundItems = false;
    private boolean viewDroppedItems = false;
    private final class_437 previousScreen;
    private static final int SLOT_SIZE = 18;
    private static final int SLOTS_PER_LINE = 9;

    public GraveOverviewGui(GraveComponent graveComponent, class_437 previousScreen, boolean canRestore, boolean canRob, boolean canDelete, boolean canUnlock, boolean obtainableKeys, boolean obtainableCompass) {
        this.graveComponent = graveComponent;
        this.previousScreen = previousScreen;
        this.root = new WPlainPanel();
        this.setRootPanel((WPanel)this.root);
        this.invPanel = new WPlainPanel();
        this.invPanel.setBackgroundPainter(BackgroundPainter.VANILLA);
        this.invPanel.setInsets(Insets.ROOT_PANEL);
        this.buttonPanel = new WPlainPanel();
        int width = this.invPanel.getWidth();
        int height = this.invPanel.getHeight();
        this.root.add((WWidget)this.invPanel, 0, 0);
        this.invPanel.setSize(width, height);
        int slightlyRight = 19;
        WLabel title = new WLabel((class_2561)this.graveComponent.getDeathMessage().getDeathMessage());
        this.invPanel.add((WWidget)title, slightlyRight, 0);
        this.addCoordinates(slightlyRight);
        this.addDimension(slightlyRight);
        this.addXpInfo(slightlyRight);
        this.addButtons(canRestore, canRob, canDelete, canUnlock, obtainableKeys, obtainableCompass);
        this.updateFilters();
        this.root.validate((GuiDescription)this);
    }

    public void addPainters() {
    }

    public class_437 getPreviousScreen() {
        return this.previousScreen;
    }

    private void updateFilters() {
        for (WWidget removable : this.removables) {
            if (removable.getParent() == null) continue;
            removable.getParent().remove(removable);
        }
        this.visibleInventoryComponent = this.graveComponent.getInventoryComponent().filteredInv(dropRule -> switch (dropRule) {
            default -> throw new IncompatibleClassChangeError();
            case DropRule.PUT_IN_GRAVE -> this.viewGraveItems;
            case DropRule.DESTROY -> this.viewDeletedItems;
            case DropRule.KEEP -> this.viewSoulboundItems;
            case DropRule.DROP -> this.viewDroppedItems;
        });
        this.addItemSlots();
    }

    private void addItemSlots() {
        class_2371 items = class_2371.method_10211();
        for (GraveItem pair : this.visibleInventoryComponent.getItems()) {
            items.add((Object)pair.stack);
        }
        items.addAll(this.visibleInventoryComponent.getAllExtraItems(true));
        int generateArmorAndOffhandFrom = Math.max(this.visibleInventoryComponent.armorSize, this.visibleInventoryComponent.offHandSize) - 1;
        this.addItemSlot(this.invPanel, this.visibleInventoryComponent.mainSize, this.visibleInventoryComponent.armorSize, (class_2371<class_1799>)items, i -> new Point(0, (generateArmorAndOffhandFrom - i) * 18));
        this.addItemSlot(this.invPanel, this.visibleInventoryComponent.mainSize + this.visibleInventoryComponent.armorSize, this.visibleInventoryComponent.offHandSize, (class_2371<class_1799>)items, i -> new Point(144, (generateArmorAndOffhandFrom - i) * 18));
        int mainInvHeight = this.visibleInventoryComponent.mainSize / 9;
        this.addItemSlot(this.invPanel, 0, 9, (class_2371<class_1799>)items, i -> new Point(i * 18, (mainInvHeight + generateArmorAndOffhandFrom + 1) * 18));
        this.addItemSlot(this.invPanel, 9, this.visibleInventoryComponent.mainSize - 9, (class_2371<class_1799>)items, i -> new Point(i % 9 * 18, (int)(((double)generateArmorAndOffhandFrom + 1.5 + (double)(i / 9)) * 18.0)));
        int collectiveSize = this.visibleInventoryComponent.mainSize + this.visibleInventoryComponent.armorSize + this.visibleInventoryComponent.offHandSize;
        int sizeDiff = items.size() - collectiveSize;
        if (sizeDiff > 0) {
            WPlainPanel extraItemsPanel = new WPlainPanel();
            extraItemsPanel.setInsets(new Insets(6));
            extraItemsPanel.setBackgroundPainter(BackgroundPainter.VANILLA);
            Insets panelInsets = this.invPanel.getInsets();
            int slotsHigh = (this.invPanel.getHeight() - (panelInsets.bottom() + panelInsets.top())) / 18;
            this.addItemSlot(extraItemsPanel, collectiveSize, sizeDiff, (class_2371<class_1799>)items, i -> new Point(i / slotsHigh * 18, i % slotsHigh * 18));
            int width = extraItemsPanel.getWidth();
            int height = extraItemsPanel.getHeight();
            this.root.add((WWidget)extraItemsPanel, 0, panelInsets.top() - extraItemsPanel.getInsets().top());
            extraItemsPanel.setSize(width, height);
            this.invPanel.setLocation(extraItemsPanel.getWidth(), 0);
            this.buttonPanel.setLocation(this.invPanel.getX() + this.invPanel.getWidth(), this.buttonPanel.getY());
            this.removables.add((WWidget)extraItemsPanel);
        } else {
            this.invPanel.setLocation(0, 0);
            this.buttonPanel.setLocation(this.invPanel.getX() + this.invPanel.getWidth(), this.buttonPanel.getY());
        }
    }

    private void addCoordinates(int x) {
        class_2338 pos = this.graveComponent.getPos();
        WText coordinates = new WText(class_2561.method_30163((String)"X: %d / Y: %d / Z: %d".formatted(pos.method_10263(), pos.method_10264(), pos.method_10260())));
        this.invPanel.add((WWidget)coordinates, x, 18, 162 - 2 * x, 18);
    }

    private void addDimension(int x) {
        class_5321<class_1937> key = this.graveComponent.getWorldRegistryKey();
        String dimId = key.method_29177().toString();
        WText dimension = new WText((class_2561)class_2561.method_48321((String)("text.yigd.dimension.name." + dimId), (String)dimId));
        this.invPanel.add((WWidget)dimension, x, 36, 162 - 2 * x, 18);
    }

    private void addXpInfo(int x) {
        WSprite xpIcon = new WSprite(new class_2960("yigd", "textures/gui/exp_orb.png"));
        int spriteSize = 12;
        this.invPanel.add((WWidget)xpIcon, x, 54, spriteSize, spriteSize);
        int level = this.graveComponent.getExpComponent().getXpLevel();
        class_2561 text = class_2561.method_30163((String)String.valueOf(level));
        WText bgTextUp = new WText(text, 0);
        WText bgTextDown = new WText(text, 0);
        WText bgTextLeft = new WText(text, 0);
        WText bgTextRight = new WText(text, 0);
        WText wText = new WText(text, 8453920);
        int textX = x + spriteSize;
        int textY = 54 + spriteSize / 2;
        this.invPanel.add((WWidget)bgTextRight, textX + 1, textY);
        this.invPanel.add((WWidget)bgTextLeft, textX - 1, textY);
        this.invPanel.add((WWidget)bgTextUp, textX, textY + 1);
        this.invPanel.add((WWidget)bgTextDown, textX, textY - 1);
        this.invPanel.add((WWidget)wText, textX, textY);
    }

    private void addItemSlot(WPlainPanel root, int fromIndex, int amount, class_2371<class_1799> items, Function<Integer, Point> posCalculation) {
        for (int i = 0; i < amount; ++i) {
            Point pos = posCalculation.apply(i);
            WItemStack wItemStack = new WItemStack((class_1799)items.get(fromIndex + i), 18);
            this.removables.add(wItemStack);
            root.add((WWidget)wItemStack, pos.x, pos.y);
        }
    }

    private void addButtons(boolean restoreBtn, boolean robBtn, boolean deleteBtn, boolean lockingBtn, boolean obtainableKeys, boolean obtainableCompass) {
        WHoverToggleButton viewGraveItems = new WHoverToggleButton((Icon)new TextureIcon(new class_2960("yigd", "textures/gui/unclaimed_grave.png")), (class_2561)class_2561.method_43471((String)"button.yigd.gui.view_grave_items"), (Icon)new TextureIcon(new class_2960("yigd", "textures/gui/unclaimed_grave_cross.png")), (class_2561)class_2561.method_43471((String)"button.yigd.gui.hide_grave_items"));
        WHoverToggleButton viewDeletedItems = new WHoverToggleButton((Icon)new TextureIcon(new class_2960("yigd", "textures/gui/trashcan_icon.png")), (class_2561)class_2561.method_43471((String)"button.yigd.gui.view_deleted_items"), (Icon)new TextureIcon(new class_2960("yigd", "textures/gui/trashcan_icon_cross.png")), (class_2561)class_2561.method_43471((String)"button.yigd.gui.hide_deleted_items"));
        WHoverToggleButton viewSoulboundItems = new WHoverToggleButton((Icon)new TextureIcon(new class_2960("textures/item/enchanted_book.png")), (class_2561)class_2561.method_43471((String)"button.yigd.gui.view_soulbound_items"), (Icon)new TextureIcon(new class_2960("yigd", "textures/gui/enchanted_book_cross.png")), (class_2561)class_2561.method_43471((String)"button.yigd.gui.hide_soulbound_items"));
        WHoverToggleButton viewDroppedItems = new WHoverToggleButton((Icon)new TextureIcon(new class_2960("yigd", "textures/gui/drop_icon.png")), (class_2561)class_2561.method_43471((String)"button.yigd.gui.view_dropped_items"), (Icon)new TextureIcon(new class_2960("yigd", "textures/gui/drop_icon_cross.png")), (class_2561)class_2561.method_43471((String)"button.yigd.gui.hide_dropped_items"));
        WHoverButton restoreButton = new WHoverButton((Icon)new TextureIcon(new class_2960("yigd", "textures/gui/restore_btn.png")), (class_2561)class_2561.method_43471((String)"button.yigd.gui.restore"));
        WHoverButton robButton = new WHoverButton((Icon)new TextureIcon(new class_2960("yigd", "textures/gui/rob_btn.png")), (class_2561)class_2561.method_43471((String)"button.yigd.gui.rob"));
        WHoverButton deleteButton = new WHoverButton((Icon)new TextureIcon(new class_2960("yigd", "textures/gui/trashcan_icon.png")), (class_2561)class_2561.method_43471((String)"button.yigd.gui.delete"));
        TextureIcon lockingIconOn = new TextureIcon(new class_2960("yigd", "textures/gui/locked_btn.png"));
        TextureIcon lockingIconOff = new TextureIcon(new class_2960("yigd", "textures/gui/unlocked_btn.png"));
        WHoverToggleButton lockingButton = new WHoverToggleButton((Icon)lockingIconOn, (class_2561)class_2561.method_43471((String)"button.yigd.gui.locked"), (Icon)lockingIconOff, (class_2561)class_2561.method_43471((String)"button.yigd.gui.unlocked"));
        lockingButton.setToggle(this.graveComponent.isLocked());
        WHoverButton obtainKeysButton = new WHoverButton((Icon)new TextureIcon(new class_2960("yigd", "textures/item/grave_key.png")), (class_2561)class_2561.method_43471((String)"button.yigd.gui.obtain_keys"));
        WHoverButton obtainCompassButton = new WHoverButton((Icon)new TextureIcon(new class_2960("textures/item/recovery_compass_18.png")), (class_2561)class_2561.method_43471((String)"button.yigd.gui.obtain_compass"));
        UUID graveId = this.graveComponent.getGraveId();
        viewGraveItems.setToggle(this.viewGraveItems);
        viewDeletedItems.setToggle(this.viewDeletedItems);
        viewSoulboundItems.setToggle(this.viewSoulboundItems);
        viewDroppedItems.setToggle(this.viewDroppedItems);
        viewGraveItems.setOnToggle(aBoolean -> {
            this.viewGraveItems = aBoolean;
            this.updateFilters();
        });
        viewDeletedItems.setOnToggle(aBoolean -> {
            this.viewDeletedItems = aBoolean;
            this.updateFilters();
        });
        viewSoulboundItems.setOnToggle(aBoolean -> {
            this.viewSoulboundItems = aBoolean;
            this.updateFilters();
        });
        viewDroppedItems.setOnToggle(aBoolean -> {
            this.viewDroppedItems = aBoolean;
            this.updateFilters();
        });
        restoreButton.setOnClick(() -> ClientPacketHandler.sendRestoreGraveRequestPacket(graveId, this.viewGraveItems, this.viewDeletedItems, this.viewSoulboundItems, this.viewDroppedItems));
        robButton.setOnClick(() -> ClientPacketHandler.sendRobGraveRequestPacket(graveId, this.viewGraveItems, this.viewDeletedItems, this.viewSoulboundItems, this.viewDroppedItems));
        deleteButton.setOnClick(() -> ClientPacketHandler.sendDeleteGraveRequestPacket(graveId));
        lockingButton.setOnToggle(aBoolean -> ClientPacketHandler.sendGraveLockRequestPacket(graveId, aBoolean));
        obtainKeysButton.setOnClick(() -> ClientPacketHandler.sendObtainKeysRequestPacket(graveId));
        obtainCompassButton.setOnClick(() -> ClientPacketHandler.sendObtainCompassRequestPacket(graveId));
        int x = 0;
        boolean y = false;
        int i = 0;
        this.buttonPanel.setBackgroundPainter(BackgroundPainter.VANILLA);
        this.buttonPanel.setInsets(new Insets(6));
        this.buttonPanel.add((WWidget)viewGraveItems, x, 0);
        this.buttonPanel.add((WWidget)viewDeletedItems, x, 0 + (i += 22));
        this.buttonPanel.add((WWidget)viewSoulboundItems, x, 0 + (i += 22));
        this.buttonPanel.add((WWidget)viewDroppedItems, x, 0 + (i += 22));
        i = 0;
        x += 22;
        if (restoreBtn) {
            this.buttonPanel.add((WWidget)restoreButton, x, 0);
            i += 22;
        }
        if (robBtn) {
            this.buttonPanel.add((WWidget)robButton, x, 0 + i);
            i += 22;
        }
        if (lockingBtn) {
            this.buttonPanel.add((WWidget)lockingButton, x, 0 + i);
            i += 22;
        }
        if (deleteBtn) {
            this.buttonPanel.add((WWidget)deleteButton, x, 0 + i);
            i += 22;
        }
        if (obtainableKeys) {
            this.buttonPanel.add((WWidget)obtainKeysButton, x, 0 + i);
            i += 22;
        }
        if (obtainableCompass) {
            this.buttonPanel.add((WWidget)obtainCompassButton, x, 0 + i);
        }
        int width = this.buttonPanel.getWidth();
        int height = this.buttonPanel.getHeight();
        this.root.add((WWidget)this.buttonPanel, this.invPanel.getX() + this.invPanel.getWidth(), this.invPanel.getInsets().top() - this.buttonPanel.getInsets().top());
        this.buttonPanel.setSize(width, height);
    }
}

